% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CyNDEx.R
\name{updateNetworkInNDEx}
\alias{updateNetworkInNDEx}
\title{Update Network In NDEx}
\usage{
updateNetworkInNDEx(
  username,
  password,
  isPublic,
  network = NULL,
  metadata = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{username}{NDEx account username}

\item{password}{NDEx account password}

\item{isPublic}{(Boolean) Whether to make the network publicly 
accessible at NDEx.}

\item{network}{(optional) Name or SUID of the network. Default is the "current" 
network active in Cytoscape.}

\item{metadata}{(optional) A list of structured information describing the network}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
NDEx identifier (\code{externalId}) for the updated submission
}
\description{
Update an existing network in NDEx, given a previously 
assoicaiated Cytoscape network, e.g., previously exported to NDEx or imported
from NDEx.
}
\examples{
\donttest{
updateNetworkInNDEx("user", "pass", TRUE)
}
}
