% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Styles.R
\name{createVisualStyle}
\alias{createVisualStyle}
\title{Create a visual style from components}
\usage{
createVisualStyle(style.name, defaults, mappings, base.url = .defaultBaseUrl)
}
\arguments{
\item{style.name}{(char) name for style}

\item{defaults}{(list) key-value pairs for default mappings.}

\item{mappings}{(list) visual property mappings, see mapVisualProperty}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Create a style from defaults and predefined mappings.
}
\details{
Requires attribute mappings to be previously created, see mapVisualProperty.
}
\examples{
\donttest{
#first there has to be a network to apply style to
example(createNetworkFromDataFrames)

#then prepare style variables
style.name = "myStyle"
defaults <- list(NODE_SHAPE="diamond",
                 NODE_SIZE=30,
                 EDGE_TRANSPARENCY=120,
                 NODE_LABEL_POSITION="W,E,c,0.00,0.00")
nodeLabels <- mapVisualProperty('node label','id','p')
nodeFills <- mapVisualProperty('node fill color','group','d',c("A","B"), c("#FF9900","#66AAAA"))
arrowShapes <- mapVisualProperty('Edge Target Arrow Shape','interaction','d',
                                 c("activates","inhibits","interacts"),c("Arrow","T","None"))
edgeWidth <- mapVisualProperty('edge width','weight','p')

#and then create the style
createVisualStyle(style.name, defaults, list(nodeLabels,nodeFills,arrowShapes,edgeWidth))

#finsh by applying the style
setVisualStyle(style.name)
}
}
\seealso{
applyStyle, mapVisualProperty
}
