% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StyleBypasses.R
\name{setEdgeSourceArrowShapeBypass}
\alias{setEdgeSourceArrowShapeBypass}
\title{Set Edge Source Arrow Shape Bypass}
\usage{
setEdgeSourceArrowShapeBypass(
  edge.names,
  new.shapes,
  network = NULL,
  base.url = .defaultBaseUrl
)
}
\arguments{
\item{edge.names}{List of edge names or SUIDs}

\item{new.shapes}{List of shapes, or single value. See \link{getArrowShapes}.}

\item{network}{(optional) Name or SUID of the network. Default is the 
"current" network active in Cytoscape.}

\item{base.url}{(optional) Ignore unless you need to specify a custom domain,
port or version to connect to the CyREST API. Default is http://localhost:1234
and the latest version of the CyREST API supported by this version of RCy3.}
}
\value{
None
}
\description{
Override the source arrow shape for particular edges.
}
\details{
This method permanently overrides any default values or mappings 
defined for this visual property of the edge or edges specified. This method
ultimately calls the generic function, \link{setEdgePropertyBypass}, which 
can be used to set any visual property. To restore defaults and mappings, use
 \link{clearEdgePropertyBypass}.
}
\examples{
\donttest{
setEdgeSourceArrowShapeBypass()
}
}
\seealso{
{
\link{setEdgePropertyBypass},
\link{clearEdgePropertyBypass}
}
}
