% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_plotRespFun.R
\name{plotRespFun}
\alias{plotRespFun}
\title{Plot the non-parametric response functions}
\usage{
plotRespFun(
  RCM,
  taxa = NULL,
  type = "link",
  logTransformYAxis = FALSE,
  addSamples = TRUE,
  samSize = NULL,
  Dim = 1L,
  nPoints = 100L,
  labSize = 2.5,
  yLocVar = NULL,
  yLocSam = NULL,
  Palette = "Set3",
  addJitter = FALSE,
  nTaxa = 9L,
  angle = 90,
  legendLabSize = 15,
  legendTitleSize = 16,
  axisLabSize = 14,
  axisTitleSize = 16,
  lineSize = 0.75,
  ...
)
}
\arguments{
\item{RCM}{an RCM object}

\item{taxa}{a character vector of taxa to be plotted}

\item{type}{a character string, plot the response function on the log-scale
('link') or the abundance scale 'response', similar to predict.glm().}

\item{logTransformYAxis}{a boolean, should y-axis be log transformed?}

\item{addSamples}{a boolean, should sample points be shown?}

\item{samSize}{a sample variable name or a vector of length equal to the
number of samples, for the sample sizes}

\item{Dim}{An integer, the dimension to be plotted}

\item{nPoints}{the number of points to be used to plot the lines}

\item{labSize}{the label size for the variables}

\item{yLocVar}{the y-location of the variables, recycled if necessary}

\item{yLocSam}{the y-location of the samples, recycled if necessary}

\item{Palette}{which color palette to use}

\item{addJitter}{A boolean, should variable names be jittered to make
them more readable}

\item{nTaxa}{an integer, number of taxa to plot}

\item{angle}{angle at which variable labels should be turned}

\item{legendLabSize}{size of the legend labels}

\item{legendTitleSize}{size of the legend title}

\item{axisLabSize}{size of the axis labels}

\item{axisTitleSize}{size of the axis title}

\item{lineSize}{size of the response function lines}

\item{...}{Other argumens passed on to the ggplot() function}
}
\value{
Plots a ggplot2-object to output
}
\description{
Plots a number of response functions over the observed range of
 the environmental score. If no taxa are provided those who react most
 strongly to the environmental score are chosen.
}
\examples{
data(Zeller)
require(phyloseq)
tmpPhy = prune_taxa(taxa_names(Zeller)[1:100],
prune_samples(sample_names(Zeller)[1:50], Zeller))
#Subset for a quick fit
zellerRCMnp = RCM(tmpPhy, k = 2,
covariates = c('BMI','Age','Country','Diagnosis','Gender'),
round = TRUE, responseFun = 'nonparametric')
plotRespFun(zellerRCMnp)
}
\seealso{
\code{\link{RCM}}, \code{\link{plot.RCM}},\code{\link{residualPlot}}
}
