% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quheatmap.R
\name{quheatmap}
\alias{quheatmap}
\title{Visualization of identified biclusters}
\usage{
quheatmap(x, bicResult, number = 1, showlabel = FALSE, col = c("#313695",
  "#4575B4", "#74ADD1", "#ABD9E9", "#E0F3F8", "#FFFFBF", "#FEE090", "#FDAE61",
  "#F46D43", "#D73027", "#A50026"), ...)
}
\arguments{
\item{x}{The data matrix}

\item{bicResult}{biclust::BiclustResult object}

\item{number}{which bicluster to be plotted}

\item{showlabel}{If TRUE, show the xlabel and ylabel}

\item{col}{default: c("#313695", "#4575B4", "#74ADD1", "#ABD9E9", "#E0F3F8", "#FFFFBF", "#FEE090", "#FDAE61", "#F46D43", "#D73027", "#A50026")}

\item{...}{Additional options in \code{fields::image.plot}}
}
\description{
This function can visualize the identifed biclusters using heatmap in support of overall expression pattern analysis,either for a single bicluster or two biclusters.
}
\examples{
# Load microarray matrix
data(BicatYeast)
res <- biclust::biclust(BicatYeast, method=BCQU(), verbose = FALSE)
# Draw heatmap for the 2th identified bicluster
par(mar = c(5, 4, 3, 5) + 0.1, mgp = c(0, 1, 0), cex.lab = 1.1, cex.axis = 0.5, cex.main = 1.1)
quheatmap(x = BicatYeast, res, number = 2, showlabel = TRUE)
# Draw heatmap for the 2th and 3th identified biclusters.
par(mar = c(5, 5, 5, 5), cex.lab = 1.1, cex.axis = 0.5, cex.main = 1.1)
quheatmap(x = BicatYeast, res, number = c(2, 3), showlabel = TRUE)
}
\seealso{
\code{\link{qunet2xml}} \code{\link{QUBIC}} \code{\link{heatmapBC}}
}

