% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_autocorrelation.R
\name{calculate_autocorrelation}
\alias{calculate_autocorrelation}
\title{Calculate the autocorrelation for each protein between a pair of co-elution 
experiments.}
\usage{
calculate_autocorrelation(
  profile1,
  profile2,
  cor_method = c("pearson", "spearman", "kendall"),
  min_replicates = 1,
  min_fractions = 1,
  min_pairs = 0
)
}
\arguments{
\item{profile1}{a numeric matrix or data frame with proteins in rows and 
fractions in columns, or a \code{\linkS4class{MSnSet}} object, representing
the first co-elution condition}

\item{profile2}{a numeric matrix or data frame with proteins in rows and 
fractions in columns, or a \code{\linkS4class{MSnSet}} object, representing
the second co-elution condition}

\item{cor_method}{the correlation method to use; one of \code{"pearson"},
\code{"spearman"}, or \code{"kendall"}).}

\item{min_fractions}{filter proteins not quantified in at least this many
fractions}

\item{min_pairs}{remove correlations between protein pairs not co-occuring in
at least this many fractions from the autocorrelation calculation}
}
\value{
a named vector of autocorrelation scores for all proteins found in
both matrices.
}
\description{
For a given protein, the correlation coefficient to all other proteins 
in the first condition is calculated, yielding a vector of correlation 
coefficients. The same procedure is repeated for the second condition,
and the two vectors of correlation coefficients are themselves correlated,
yielding a metric whereby higher values reflect proteins with unchanging
interaction profiles between conditions, while lower values reflect proteins 
with substantially changing interaction profiles.
}
\details{
Note that all of zero, \code{NA}, \code{NaN}, and infinite values are
all treated equivalently as missing values when applying the 
\code{min_fractions} and \code{min_pairs} filters, but different handling of 
missing values will produce different autocorrelation scores.
}
