% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFuncs.R
\name{update_conditions_with_lcs}
\alias{update_conditions_with_lcs}
\title{Update Conditions with Longest Common Subsequence}
\usage{
update_conditions_with_lcs(fulldata, default = NULL)
}
\arguments{
\item{fulldata}{A SummarizedExperiment or derived object that contains
the quantitative data as specified for PolySTest}

\item{default}{A vector of the length of the number of conditions suggesting
their names}
}
\value{
SummarizedExperiment with updated conditions
}
\description{
This function iterates over a set of conditions and updates each condition
with the longest common subsequence of column names associated with that
condition.
}
\examples{
library(SummarizedExperiment)
se <- SummarizedExperiment(assays = list(count = matrix(rnorm(200),
    ncol = 10
)))
metadata(se) <- list(NumCond = 2, NumReps = 5)
rownames(colData(se)) <- paste0(
    rep(c("CondA_Rep", "CondB_Rep"), 5),
    rep(seq_len(5), each = 2)
)
default_conditions <- c("Condition_A", "Condition_B")
updated_conditions <- update_conditions_with_lcs(se, default_conditions)
print(colData(updated_conditions))
}
