% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFuncs.R
\name{RPStats}
\alias{RPStats}
\title{RPStats Function}
\usage{
RPStats(tRPMAData, NumReps)
}
\arguments{
\item{tRPMAData}{A matrix containing the expression data with rows as
features and columns as replicates.}

\item{NumReps}{The number of replicates for each feature.}
}
\value{
A numeric vector containing the p-values for the RP statistic.
}
\description{
This function calculates the p-values for the RP (Rank Product) statistic
based on the input tRPMAData and the number of replicates (NumReps).
The statistcs is one-sided, i.e. it only detects up-regulation.
}
\examples{
tRPMAData <- matrix(c(1, 2, 3, 4, 5, 6), nrow = 2, ncol = 3)
NumReps <- 3
RPStats(tRPMAData, NumReps)

}
