% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HelperFuncs.R
\name{MissingStatsDesign}
\alias{MissingStatsDesign}
\title{Function of calculation of Miss tests. This happens between full
groups and thus does not have distinction for pairwise testing.}
\usage{
MissingStatsDesign(Data, RRCateg, NumCond, NumReps)
}
\arguments{
\item{Data}{A matrix containing the expression data with rows as features and
columns as samples}

\item{RRCateg}{A matrix containing the indices of the conditions to compare
(each row is a pairing)}

\item{NumCond}{The number of conditions in the dataset}

\item{NumReps}{The number of replicates for each condition (needs to be same
for all conditions)}
}
\value{
A list containing the calculated p-values and q-values
(Benjamini-Hochbeg) for missingness statistics
}
\description{
Function of calculation of Miss tests. This happens between full
groups and thus does not have distinction for pairwise testing.
}
\examples{
Data <- matrix(rnorm(120), nrow = 10)
# Introduce some missingness
Data[sample(seq_len(120), 40)] <- NA
RRCateg <- matrix(c(1, 2, 1, 3, 1, 4, 2, 3, 2, 4, 3, 4), nrow = 2, ncol = 6)
NumCond <- 4
NumReps <- 3
res_misstest <- MissingStatsDesign(Data, RRCateg, NumCond, NumReps)
head(res_misstest$qNAvalues)

}
