% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline_impute.R
\name{pipeline_llkimpute}
\alias{pipeline_llkimpute}
\alias{my_pipeline_llkimpute}
\title{Pirat imputation function}
\usage{
my_pipeline_llkimpute(data.pep.rna.mis, ...)

pipeline_llkimpute(
  data.pep.rna.mis,
  pep.ab.comp = NULL,
  alpha.factor = 2,
  rna.cond.mask = NULL,
  pep.cond.mask = NULL,
  extension = c("base", "2", "T", "S"),
  mcar = FALSE,
  degenerated = FALSE,
  max.pg.size.pirat.t = 1,
  verbose = FALSE,
  version = "accelerated"
)
}
\arguments{
\item{data.pep.rna.mis}{Parameter 'data.pep.rna.mis' of the function 
`pipeline_llkimpute()`}

\item{...}{Additional parameters for the function `pipeline_llkimpute()`}

\item{pep.ab.comp}{The pseudo-complete peptide or precursor abundance matrix,
with samples in row and peptides or precursors in column. Useful only in 
mask-and-impute experiments, if one wants to impute solely peptides 
containing pseudo-MVs.}

\item{alpha.factor}{Factor that multiplies the parameter alpha of the 
penalty described in the original paper.}

\item{rna.cond.mask}{Vector of indexes representing conditions of samples 
of mRNA table, only mandatory if extension == "T". For paired proteomic and 
transcriptomic tables, should be c(1:n_samples).}

\item{pep.cond.mask}{Vector of indexes representing conditions of samples 
of mRNA table, only mandatory if extension == "T". For paired proteomic 
and transcriptomic tables, should be c(1:n_samples).}

\item{extension}{If NULL (default), classical Pirat is applied. If "2", 
only imputes PGs containing at least 2 peptides or precursors, and 
remaining peptides are left unchanged.
If "S", Pirat-S is applied, considering sample-wise correlations only for
 singleton PGs.
It "T", Pirat-T is applied, thus requiring **rnas_ab** and **adj_rna_pg** 
in list **data.pep.rna.mis**, as well as non-NULL **rna.cond.mask** and 
**pep.cond.mask**.
Also, the maximum size of PGs for which transcriptomic data can be used is 
controlled with **max.pg.size.pirat.t**.}

\item{mcar}{If TRUE, forces gamma_1 = 0, thus no MNAR mechanism is 
considered.}

\item{degenerated}{If TRUE, applies Pirat-Degenerated (i.e. its univariate 
alternative) as described in original paper. Should not be TRUE unless for 
experimental purposes.}

\item{max.pg.size.pirat.t}{When extension == "T", the maximum PG size for 
which transcriptomic information is used for imputation.}

\item{verbose}{A boolean (FALSE as default) which indicates whether to 
display more details on the process.}

\item{version}{Version to use, either "original_BSTS_2025" for the original 
version or "accelerated" (default) a faster modified version.}
}
\value{
The imputed **data.pep.rna.mis$peptides_ab** table.

The imputed **data.pep.rna.mis$peptides_ab** table.

NA
}
\description{
Imputation pipeline of Pirat. First, it creates PGs. Then,
it estimates parameters of the penalty term (that amounts to an
inverse-Wishart prior). Second, it estimates the missingness mechanism
parameters. Finally, it imputes the peptide/precursor-level dataset with 
desired extension.
}
\examples{
# Pirat classical mode
data(subbouyssie)
myResult <- my_pipeline_llkimpute(subbouyssie)

# Pirat with transcriptomic integration for singleton PGs
data(subropers)
nsamples = nrow(subropers$peptides_ab)
myResult <- my_pipeline_llkimpute(subropers, 
extension = "T",
rna.cond.mask = seq(nsamples), 
pep.cond.mask = seq(nsamples),
max.pg.size.pirat.t = 1)

\dontrun{
myResult <- pipeline_llkimpute(subbouyssie)
}
}
\seealso{
[pipeline_llkimpute()]
}
