% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pirat_utils.R
\name{impute_block_llk_reset}
\alias{impute_block_llk_reset}
\title{Impute each PG.}
\usage{
impute_block_llk_reset(
  data.pep.rna.crop,
  psi,
  pep_ab_or = NULL,
  df = 1,
  nu_factor = 2,
  max_pg_size = NULL,
  min.pg.size2imp = 1,
  verbose = FALSE,
  version = "accelerated",
  ...
)
}
\arguments{
\item{data.pep.rna.crop}{A list representing dataset}

\item{psi}{Inverse scale parameter for IW prior of peptides abundances}

\item{pep_ab_or}{In case we impute a dataset with pseudo-MVS, we can provide
 the ground truth abundance table, 
such that imputation will by done only for pseudo-MVs. This will accelerate 
imputation algorithm.}

\item{df}{Estimate degree of freedom of the IG distribution fitted on 
observed variance.}

\item{nu_factor}{Multiplication factor on degree of freedom. 2 by default.}

\item{max_pg_size}{Maximum PGs size authorized for imputation. PG size is 
plitted if its size is above this threshold.}

\item{min.pg.size2imp}{Minimum PG size to impute after splitting. PGs for 
which size is greater are not imputed. Should be lower than max_pg_size to 
have effect.}

\item{verbose}{A boolean (FALSE as default) which indicates whether to 
display more details on the process}

\item{version}{Version to use, either "original_BSTS_2025" for the original 
version or "accelerated" (default) a faster modified version.}

\item{...}{Additional arguments}
}
\value{
A list containing imputation results for each PG, the execution time,
 and adjacency matrix between peptides and PGs corresponding to the 
 imputed PGs.
}
\description{
Imputes each PG separately and return the results for each PG.
}
\examples{
\dontrun{
Py_impute_block_llk_reset <- function(data.pep.rna.mis, psi) { 
proc <- basilisk::basiliskStart(envPirat)

func <- basilisk::basiliskRun(proc, 
    fun = function(arg1, arg2) {
        
        imputed_pgs <- Pirat::impute_block_llk_reset(arg1, arg2)
        imputed_pgs 
    }, arg1 = data.pep.rna.mis, arg2 = psi)

basilisk::basiliskStop(proc)
func
}

data(subbouyssie)
obs2NApep <- subbouyssie$peptides_ab[ ,colSums(is.na(subbouyssie$peptides_ab)) <= 0] 
res_hyperparam <- estimate_psi_df(obs2NApep)
psi <- res_hyperparam$psi
Py_impute_block_llk_reset(subbouyssie, psi)
}

}
