% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhenoGeneRankerFunctions.R
\name{CreateWalkMatrix}
\alias{CreateWalkMatrix}
\title{Create Walk Matrix}
\usage{
CreateWalkMatrix(
  inputFileName,
  numCores = 1,
  delta = 0.5,
  zeta = 0.5,
  lambda = 0.5
)
}
\arguments{
\item{inputFileName}{The name of the text file that contains the names of
gene and phenotype network files. For more information on the file formatting, 
please refer the vignette.}

\item{numCores}{This is the number of cores used for parallel processing.}

\item{delta}{This is the probability of jumping between gene layers. High delta means 
RWR  is high likely to jump to other layers in gene multiplex network. It has a default value of 0.5.}

\item{zeta}{This is the probability of jumping between phenotype layers. High zeta means 
RWR  is high likely to jump to other layers in phenotype multiplex network. It has a default value of 0.5.}

\item{lambda}{This is the probability of jumping between gene and phenotype multiplex networks. High lambda
means RWR is more likely to exploit the bipartite relation. It has a default value of 0.5.}
}
\value{
This returns a list containing the walk matrix, a sorted list of gene ids, a sorted list of phenotype ids,
 the connectivity degree of the genes, the connectivity degree of the phenotypes, the number of gene layers, 
 the number of phenotype layers, the number of genes and the number of phenotypes in the final complex network.
}
\description{
Generates a Walk Matrix (Transition Matrix) from Gene and Phenotype networks for RWR.
}
\examples{
wm <- CreateWalkMatrix('input_file.txt')
customWm <- CreateWalkMatrix('input_file.txt', numCores=1, delta=0.7, zeta=0.7, lambda=0.7)


}
