% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterNoisyCurves.R
\name{filterNoisyCurves}
\alias{filterNoisyCurves}
\title{Viability measurements in dose-reponse curves must remain stable or decrease
monotonically reflecting response to the drug being tested.
filterNoisyCurves flags dose-response curves that strongly violate these
assumptions.}
\usage{
filterNoisyCurves(
  pSet,
  epsilon = 25,
  positive.cutoff.percent = 0.8,
  mean.viablity = 200,
  nthread = 1
)
}
\arguments{
\item{pSet}{\link{PharmacoSet} a PharmacoSet object}

\item{epsilon}{\code{numeric} a value indicates assumed threshold for the
distance between to consecutive viability values on the drug-response curve
in the analysis, out of dna, rna, rnaseq, snp, cnv}

\item{positive.cutoff.percent}{\code{numeric} This value indicates that function
may violate epsilon rule for how many points on drug-response curve}

\item{mean.viablity}{\code{numeric} average expected viability value}

\item{nthread}{\code{numeric} if multiple cores are available, how many cores
should the computation be parallelized over?}
}
\value{
a list with two elements 'noisy' containing the rownames of the
noisy curves, and 'ok' containing the rownames of the non-noisy curves
}
\description{
Viability measurements in dose-reponse curves must remain stable or decrease
monotonically reflecting response to the drug being tested.
filterNoisyCurves flags dose-response curves that strongly violate these
assumptions.
}
\examples{
data(GDSCsmall)
filterNoisyCurves(GDSCsmall)

}
