% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\name{computeZIP}
\alias{computeZIP}
\title{Computes ZIP Null References}
\usage{
computeZIP(
  treatment1dose,
  HS_1,
  EC50_1,
  E_inf_1,
  treatment2dose,
  HS_2,
  EC50_2,
  E_inf_2
)
}
\arguments{
\item{treatment1dose}{\code{numeric} a vector of concentrations for treatment 1}

\item{HS_1}{\code{numeric} Hill coefficient of treatment 1}

\item{EC50_1}{\code{numeric} relative EC50 of treatment 1.}

\item{E_inf_1}{\code{numeric} viability produced by the maximum attainable effect of treatment 1.
Default 0 by the original paper.}

\item{treatment2dose}{\code{numeric} a vector of concentrations for treatment 2}

\item{HS_2}{\code{numeric} Hill coefficient of treatment 2}

\item{EC50_2}{\code{numeric} relative EC50 of treatment 2.}

\item{E_inf_2}{\code{numeric} viability produced by maximum effect of treatment 2.
Default 0 by the original paper.}
}
\value{
\code{numeric} expected viability under ZIP null assumption.
}
\description{
Predict the additive response of a treatment combination under
the ZIP null assumption.
}
\examples{
(zip <- computeZIP(
  treatment1dose = c(0.1, 0.01, 0.001),
  treatment2dose = c(1, 0.1, 0.01),
  HS_1 = rep(1, 3), HS_2 = rep(1.2, 3),
  EC50_1 = rep(0.01, 3), EC50_2 = rep(0.1, 3),
  E_inf_1 = rep(0, 3), E_inf_2 = rep(0.1, 3)
))

}
