% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSynergy.R
\name{computeLoewe}
\alias{computeLoewe}
\title{Computes Loewe Null References}
\usage{
computeLoewe(
  treatment1dose,
  HS_1,
  E_inf_1,
  EC50_1,
  treatment2dose,
  HS_2,
  E_inf_2,
  EC50_2,
  tol = 0.1,
  lower_bound = 0,
  upper_bound = 1,
  verbose = FALSE
)
}
\arguments{
\item{treatment1dose}{\code{numeric} a vector of concentrations for treatment 1}

\item{HS_1}{\code{numeric} Hill coefficient of treatment 1}

\item{E_inf_1}{\code{numeric} viability produced by the maximum attainable effect of treatment 1.}

\item{EC50_1}{\code{numeric} relative EC50 of treatment 1.}

\item{treatment2dose}{\code{numeric} a vector of concentrations for treatment 2}

\item{HS_2}{\code{numeric} Hill coefficient of treatment 2}

\item{E_inf_2}{\code{numeric} viability produced by the maximum attainable effect of treatment 2.}

\item{EC50_2}{\code{numeric} relative EC50 of treatment 2.}

\item{tol}{\code{numeric} Error tolerance for deviations from Loewe assumption. Loewe predictions with error higher than \code{tol} will be returned as \code{NA}. Deafult 0.1.}

\item{lower_bound}{\code{numeric} Lowest possible value for Loewe expected viability. Default 0.}

\item{upper_bound}{\code{numeric} Highest possible value for Loewe expected viability. Default 1.}

\item{verbose}{\code{logical} whether to display warning messages. Default \code{FALSE}.}
}
\value{
\code{numeric} expected viability under Loewe additive null assumption.
}
\description{
Predict the response of a treatment combination under
the Loewe additive null assumption.
}
\examples{
\dontrun{
tre |>
    endoaggregate(
        assay="combo_viability",
        Loewe = computeLoewe(
            treatment1dose=treatment1dose,
            treatment2dose=treatment2dose,
            HS_1=HS_1,
            HS_2=HS_2,
            E_inf_1=E_inf_1,
            E_inf_2=E_inf_2,
            EC50_1=EC50_1,
            EC50_2=EC50_2
        ),
        by = assayKeys(tre, "combo_viability")
    ) -> tre
}

}
