% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_dist_inf.R
\name{min_dist_inf}
\alias{min_dist_inf}
\alias{min_dist_inf,character-method}
\alias{min_dist_inf,Pedigree-method}
\alias{min_dist_inf,Ped-method}
\title{Minimum distance to the informative individuals}
\usage{
\S4method{min_dist_inf}{character}(obj, dadid, momid, sex, id_inf)

\S4method{min_dist_inf}{Pedigree}(obj, reset = FALSE, ...)

\S4method{min_dist_inf}{Ped}(obj, reset = FALSE)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{...}{Additional arguments}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{sex}{A character, factor or numeric vector corresponding to
the gender of the individuals. This will be transformed to an ordered factor
with the following levels:
\code{male} < \code{female} < \code{unknown}

The following values are recognized:
\itemize{
\item "male": "m", "male", "man", \code{1}
\item "female": "f", "female", "woman", \code{2}
\item "unknown": "unknown", \code{3}
}}

\item{id_inf}{An identifiers vector of informative individuals.}

\item{reset}{If TRUE, the \code{kin} and if \code{isinf} columns is reset}
}
\value{
\subsection{When obj is a vector}{

A vector of the minimum distance between the informative individuals
and all the others corresponding to the order of the individuals in the
\code{obj} vector.
}

\subsection{When obj is a Pedigree}{

The Pedigree object with a new slot named 'kin' containing the minimum
distance between each individuals and the informative individuals.
The \code{isinf} slot is also updated with the informative individuals.
}
}
\description{
Compute the minimum distance between the informative
individuals and all the others.
This distance is a transformation of the maximum kinship degree between
the informative individuals and all the others.
This transformation is done by taking the log2 of the inverse of the
maximum kinship degree.

\eqn{minDist = log2(1 / \max(kinship))}

Therefore, the minimum distance is 1 when the maximum kinship is 0.5
(i.e. same individual) and is infinite when the maximum kinship is 0
(i.e. not related).

For siblings, the kinship value is 0.25 and the minimum distance is 2.
Each time the kinship degree is divided by 2, the minimum distance is
increased by 1.
}
\examples{

min_dist_inf(
    c("A", "B", "C", "D", "E"),
    c("C", "D", "0", "0", "0"),
    c("E", "E", "0", "0", "0"),
    sex = c(1, 2, 1, 2, 1),
    id_inf = c("D", "E")
)

data(sampleped)
pedi <- is_informative(
    Pedigree(sampleped),
    informative = "AvAf", col_aff = "affection"
)
kin(ped(min_dist_inf(pedi, col_aff = "affection")))
}
\seealso{
\code{\link[=kinship]{kinship()}}
}
