% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_colors.R
\name{generate_fill}
\alias{generate_fill}
\title{Process the filling colors based on affection}
\usage{
generate_fill(
  values,
  affected,
  labels,
  is_num = NULL,
  keep_full_scale = FALSE,
  breaks = 3,
  colors_aff = c("yellow2", "red"),
  colors_unaff = c("white", "steelblue4"),
  colors_na = "grey"
)
}
\arguments{
\item{values}{The vector containing the values to process as affection.}

\item{affected}{A logical vector with the affection status of the
individuals
(i.e. \code{FALSE} = unaffected,
\code{TRUE} = affected,
\code{NA} = unknown).}

\item{labels}{The vector containing the labels to use for the affection.}

\item{is_num}{Boolean defining if the values need to be considered as
numeric.}

\item{keep_full_scale}{Boolean defining if the affection values need to
be set as a scale. If \code{values} is numeric the filling scale will be
calculated based on the values and the number of breaks given.
If \code{values} isn't numeric then each levels will get it's own color}

\item{breaks}{Number of breaks to use when using full scale with numeric
values. The same number of breaks will be done for values from affected
individuals and unaffected individuals.}

\item{colors_aff}{Set of increasing colors to use for the filling of the
affected individuls.}

\item{colors_unaff}{Set of increasing colors to use for the filling of the
unaffected individuls.}

\item{colors_na}{Color to use for individuals with no informations.}
}
\value{
A list of three elements
\itemize{
\item \code{mods} : The processed values column as a numeric factor
\item \code{affected} : A logical vector indicating if the individual
is affected
\item \code{sc_fill} : A dataframe containing the description of each
modality of the scale
}
}
\description{
Perform transformation uppon a column given as the one
containing affection status to compute the filling color.
}
\details{
The colors will be set using the
\code{\link[grDevices:colorRamp]{grDevices::colorRampPalette()}} function
with the colors given as parameters.

The colors will be set as follow:
\itemize{
\item If \strong{keep_full_scale} is \code{FALSE}:
Then the affected individuals will get the first color of the
\strong{colors_aff} vector and the unaffected individuals will get the
first color of the \strong{colors_unaff} vector.
\item If \strong{keep_full_scale} is \code{TRUE}:
\itemize{
\item If \strong{values} isn't numeric:
Each levels of the affected \strong{values} vector will get
it's own color from the \strong{colors_aff} vector using the
\code{\link[grDevices:colorRamp]{grDevices::colorRampPalette()}} and
the same will be done for the unaffected individuals using the
\strong{colors_unaff}.
\item If \strong{values} is numeric:
The mean of the affected individuals will be compared to the mean of the
unaffected individuals and the colors will be set up such as the color
gradient follow the direction of the affection.
}
}
}
\examples{
aff <- generate_aff_inds(seq_len(5), threshold = 3, sup_thres_aff = TRUE)
generate_fill(seq_len(5), aff$affected, aff$labels)
generate_fill(seq_len(5), aff$affected, aff$labels, keep_full_scale = TRUE)
}
\keyword{generate_scales}
\keyword{internal}
