% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_aff_inds.R
\name{generate_aff_inds}
\alias{generate_aff_inds}
\title{Process the affection informations}
\usage{
generate_aff_inds(
  values,
  mods_aff = NULL,
  threshold = NULL,
  sup_thres_aff = NULL,
  is_num = NULL
)
}
\arguments{
\item{values}{Vector containing the values of the column to process.}

\item{mods_aff}{Vector of modality to consider as affected in the case
where the \code{values} is a factor.}

\item{threshold}{Numeric value separating the affected and healthy subject
in the case where the \code{values} is numeric.}

\item{sup_thres_aff}{Boolean defining if the affected individual are above
the threshold or not.
If \code{TRUE}, the individuals will be considered affected
if the value of \code{values} is stricly above the \code{threshold}.
If \code{FALSE}, the individuals will be considered affected if the
value is stricly under the \code{threshold}.}

\item{is_num}{Boolean defining if the values need to be considered as
numeric.}
}
\value{
A dataframe with the \code{affected} column processed accordingly.
The different columns are:
\itemize{
\item \code{mods}: The different modalities of the column
\item \code{labels}: The labels of the different modalities
\item \code{affected}: The column processed to have only TRUE/FALSE values
}
}
\description{
Perform transformation uppon a vector given as the one
containing the affection status to obtain an \code{affected} binary state.
}
\details{
This function helps to configure a binary state from a character or
numeric variable.
\subsection{If the variable is a \code{character} or a \code{factor}:}{

In this case the affected state will depend on the modality provided as
an affected status. All individuals with a value corresponding to one of the
element in the vector \strong{mods_aff} will be considered as affected.
}

\subsection{If the variable is \code{numeric}:}{

In this case the affected state will be \code{TRUE} if the value of
the individual is above the \strong{threshold} if \strong{sup_thres_aff}
is \code{TRUE} and \code{FALSE} otherwise.
}
}
\examples{
generate_aff_inds(c(1, 2, 3, 4, 5), threshold = 3, sup_thres_aff = TRUE)
generate_aff_inds(c("A", "B", "C", "A", "V", "B"), mods_aff = c("A", "B"))
}
\keyword{generate_scales,}
\keyword{internal}
