% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_avail_noninform.R
\name{find_avail_noninform}
\alias{find_avail_noninform}
\alias{find_avail_noninform,Ped-method}
\alias{find_avail_noninform,Pedigree-method}
\title{Find uninformative but available subject}
\usage{
\S4method{find_avail_noninform}{Ped}(obj, avail = NULL, affected = NULL)

\S4method{find_avail_noninform}{Pedigree}(obj, avail = NULL, affected = NULL)
}
\arguments{
\item{obj}{A Ped or Pedigree object.}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}

\item{affected}{A logical vector with the affection status of the
individuals
(i.e. \code{FALSE} = unaffected,
\code{TRUE} = affected,
\code{NA} = unknown).}
}
\value{
Vector of subject ids who can be removed by having lowest
informativeness.
}
\description{
Finds subjects from among available non-parents with all affection
equal to \code{0}.
}
\details{
Identify subjects to remove from a Pedigree who are available but
non-informative (unaffected).
This is the second step to remove subjects in
\code{\link[=shrink]{shrink()}} if the Pedigree does not meet
the desired bit size.

If \strong{avail} or \strong{affected} is null, then the function will use the
corresponding Ped accessor.
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped)
find_avail_noninform(pedi)

}
\seealso{
\code{\link[=shrink]{shrink()}}
}
\keyword{internal,}
\keyword{shrink}
