% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app_data_import.R
\name{data_import_ui}
\alias{data_import_ui}
\alias{data_import_server}
\alias{data_import_demo}
\title{Shiny modules to import data files}
\usage{
data_import_ui(id)

data_import_server(
  id,
  label = "Select data file",
  help_data = NULL,
  help_data_title = "",
  help_test_data = NULL,
  help_test_data_title = "",
  dftest = datasets::mtcars,
  max_request_size = 30,
  help_colour = "grey",
  help_type = "inline"
)

data_import_demo(options = list())
}
\arguments{
\item{id}{A string.}

\item{label}{A string use to prompt the user}

\item{help_data}{A string to define the help content for the data import.
If NULL, no help content is displayed.}

\item{help_data_title}{A string to define the title of the help content.
Set it to "" to not display a title or to use the one present
in the markdown.}

\item{help_test_data}{A string to define the help content for the test data.
If NULL, no help content is displayed.}

\item{help_test_data_title}{A string to define the title of the help content.
Set it to "" to not display a title or to use the one present
in the markdown.}

\item{dftest}{A dataframe to test the function}

\item{max_request_size}{A number to define the maximum size of the file
that can be uploaded.}

\item{help_colour}{A string to define the colour of the help icon}

\item{help_type}{A string to define the type of help content
This can be "inline" or "markdown"}
}
\value{
A reactive dataframe selected by the user.
}
\description{
This module allow to import multiple type of data.
The file type currently supported are csv, txt, xls, xslx, rda and tab.
The server dynamically create a selection input if multiple
dataframe are present in the file selected.
This module is composed of two parts: the UI and the server.
The UI is called with the function \code{data_import_ui()} and the server
with the function \code{data_import_server()}.
Different options are available to the user to import the data.
}
\examples{
if (interactive()) {
    data_import_demo()
}
}
\keyword{data}
\keyword{internal}
