% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_hint.R
\name{auto_hint}
\alias{auto_hint}
\alias{auto_hint,Pedigree-method}
\title{Initial hint for a Pedigree alignment}
\usage{
\S4method{auto_hint}{Pedigree}(
  obj,
  hints = NULL,
  packed = TRUE,
  align = FALSE,
  reset = FALSE,
  align_parents = TRUE,
  force = FALSE
)
}
\arguments{
\item{obj}{A Pedigree object}

\item{hints}{A Hints object or a named list containing
\code{horder} and \code{spouse}.
If \code{NULL} then the Hints stored in \strong{obj} will be used.}

\item{packed}{Should the Pedigree be compressed.
(i.e. allow diagonal lines connecting parents to children in order
to have a smaller overall width for the plot.)}

\item{align}{For a packed Pedigree, align children under parents \code{TRUE},
to the extent possible given the page width, or align to to the left
margin \code{FALSE}.
This argument can be a two element vector, giving the alignment
parameters, or a logical value.
If \code{TRUE}, the default is \code{c(1.5, 2)}, or if numeric the routine
\code{alignped4()} will be called.}

\item{reset}{If \code{TRUE}, then even if  the Ped object has Hints, reset
them to the initial values.}

\item{align_parents}{If \code{align_parents = TRUE}, go one step further
and try to make both parents of each child have the same depth.
(This is not always possible).
It helps the drawing program by lining up pedigrees that
'join in the middle' via a marriage.}

\item{force}{If \code{force = TRUE}, the function will return the depth minus
\code{min(depth)} if \code{depth} reach a state with no founders
is not possible.}
}
\value{
The initial \linkS4class{Hints} object.
}
\description{
Compute an initial guess for the alignment of a Pedigree
}
\details{
A Pedigree structure can contain a \linkS4class{Hints} object which helps to
reorder the Pedigree (e.g. left-to-right order of children within family) so
as to plot with minimal distortion. This routine is used to create an
initial version of the hints. They can then be modified if desired.

This routine would not normally be called by a user. It moves children
within families, so that marriages are on the "edge" of a set children,
closest to the spouse. For pedigrees that have only a single connection
between two families this simple-minded approach works surprisingly well.
For more complex structures hand-tuning of the hints may be required.

When \code{auto_hint()} is called with a a vector of numbers as the
\strong{hints} argument, the values for the founder females are used to
order the founder families left to right across the plot.
The values within a sibship are used as the preliminary order of
siblings within a family; this may be changed to move one of them to the
edge so as to match up with a spouse. The actual values in the vector are
not important, only their order.
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped[sampleped$famid == 1, ])
Pedixplorer:::auto_hint(pedi)
}
\seealso{
\code{\link[=align]{align()}}, \code{\link[=best_hint]{best_hint()}}

\linkS4class{Hints}
}
\keyword{alignment,}
\keyword{auto_hint}
\keyword{internal,}
