% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{samplingDataBase}
\alias{samplingDataBase}
\title{Outputs a table of sampling data(rows are miRNA and cols are samples)}
\usage{
samplingDataBase(
  enrichNull,
  selector,
  sampRate,
  fn,
  nPaths,
  samplingDataFile,
  jackKnife = FALSE,
  saveSampling,
  numCores = 1,
  autoSeed = TRUE
)
}
\arguments{
\item{enrichNull}{Enrichment dataset with x (miRNA), y (pathway) and pval
(probability of observing x in pathway cluster).}

\item{selector}{Table with x(miRNA) in pathway cluster.}

\item{sampRate}{Sampling rate.}

\item{fn}{Methodology function.}

\item{nPaths}{Number of pathways in pathway cluster.}

\item{samplingDataFile}{If file exists, load. Else, perform random sampling}

\item{jackKnife}{If TRUE, conduct sampling with one less pathway, used for
jack knifing}

\item{saveSampling}{If TRUE, data is saved.}

\item{numCores}{number of cores used}

\item{autoSeed}{random permutations are generated based on predetermined
seeds. TRUE will give identical results in different runs.}
}
\value{
Outputs of sampling data.
}
\description{
Outputs a table of sampling data(rows are miRNA and cols are samples)
}
