% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miRNAPathwayEnrichment.R
\name{miRNAPathwayEnrichment}
\alias{miRNAPathwayEnrichment}
\title{Enrichment Probability Of miRNAs}
\usage{
miRNAPathwayEnrichment(
  mirSets,
  pathwaySets,
  geneSelection = NULL,
  mirSelection = NULL,
  fromID = "ENSEMBL",
  toID = "ENTREZID",
  minPathSize = 9,
  numCores = 1,
  outDir = ".",
  saveOutName = NULL
)
}
\arguments{
\item{mirSets}{Table of miRNAs and a list of their interactions with
genes in ENTREZ ID.}

\item{pathwaySets}{Table of pathways and a list of their interactions
with genes in ENTREZ ID.}

\item{geneSelection}{Table of genes with dtype; if not NULL, select only
genes from a given table.}

\item{mirSelection}{Table of miRNA names; if not NULL, select only miRNAs
from given table.}

\item{fromID}{ID of genes in geneSelection.}

\item{toID}{ID of genes used in pcxn and pathways set.}

\item{minPathSize}{Filter out pathways with sets less than given value.}

\item{numCores}{Number of CPU cores to use, must be at least one.}

\item{outDir}{Output directory.}

\item{saveOutName}{If not NULL, saves output as RDS using save name.}
}
\value{
Table of enrichment, each row contains mirna-pathway and its
  enrichment p-values.
}
\description{
Outputs enrichment probability of miRNAs based on pathway clusters.
}
\examples{
data(msigdb_c2)
data(targetScan_03)
miRNAPathwayEnrichment(targetScan_03[1:20],msigdb_c2[1:20])
}
