% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{jackKnifeBase}
\alias{jackKnifeBase}
\title{Outputs a table with col x (miRNA), probability of observing
k (depending on methodology) against a random distribution with
jack-knifing of the pathway cluster (removing a pathway at a time)}
\usage{
jackKnifeBase(
  selector,
  pathways,
  enrichNull,
  fn,
  jackKnifeData,
  m,
  numCores = 1
)
}
\arguments{
\item{selector}{Table with x(miRNA) in pathway cluster and observed k
(depending on methodology).}

\item{pathways}{Pathways in pathway cluster.}

\item{enrichNull}{Enrichment dataset with x (miRNA), y (pathway) and pval
(probability of observing x in pathway cluster).}

\item{fn}{Methodology function.}

\item{jackKnifeData}{Random distribution data with jack-knifing
(i.e. one less pathway)}

\item{m}{method name}

\item{numCores}{number of cores}
}
\value{
Outputs a new selector table with col x, pval_jk
}
\description{
Outputs a table with col x (miRNA), probability of observing
k (depending on methodology) against a random distribution with
jack-knifing of the pathway cluster (removing a pathway at a time)
}
