% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEAnalysis.R
\name{specify_comparisons}
\alias{specify_comparisons}
\title{Create vector of comparisons for DE analysis (either by single condition (sep = NULL) or by combined condition)}
\usage{
specify_comparisons(se, condition = NULL, sep = NULL, control = NULL)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{condition}{Column name of condition (if NULL, condition saved in SummarizedExperiment will be taken)}

\item{sep}{Separator that separates both groups in the condition vector (NULL if condition composed only of single group)}

\item{control}{String of control samples (how the control condition is named) (NULL if no control sample)}
}
\value{
Vector of comparisons for DE analysis
}
\description{
Create vector of comparisons for DE analysis (either by single condition (sep = NULL) or by combined condition)
}
\examples{
data(tuberculosis_TMT_se)
comparisons <- specify_comparisons(tuberculosis_TMT_se, condition = NULL,
                            sep = NULL, control = NULL)

}
