% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationMethods.R
\name{robnormNorm}
\alias{robnormNorm}
\title{RobNorm Normalization}
\usage{
robnormNorm(se, ain = "log2", aout = "RobNorm", on_raw = FALSE, gamma.0 = 0.1)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomic dataset}

\item{ain}{String which assay should be used as input}

\item{aout}{String which assay should be used to save normalized data}

\item{on_raw}{Boolean specifying whether normalization should be performed on raw or log2-scaled data}

\item{gamma.0}{Numeric representing the exponent of the weighted density. When the sample size
is small, the fitted population of some proteins could be locally trapped such
that the variance of those proteins was very small under a large gamma. To avoid
this, a small gamma is recommended. When sample size smaller than 40, then set
gamma to 0.5 or 0.1.}
}
\value{
SummarizedExperiment containing the RobNorm normalized data as assay (on log2 scale)
}
\description{
Log2-scaled data should be used as input (on_raw = FALSE).
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- robnormNorm(tuberculosis_TMT_se, ain = "log2",
                            aout = "RobNorm", on_raw = FALSE, gamma.0 = 0.1)

}
