% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterSamples.R
\name{plot_tot_int_samples}
\alias{plot_tot_int_samples}
\title{Plot total protein intensity per sample}
\usage{
plot_tot_int_samples(se, ain = "raw", color_by = NULL, label_by = NULL)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{ain}{String which data type should be used (default raw)}

\item{color_by}{String specifying the column to color the samples (If NULL, the condition column of the SummarizedExperiment object is used. If "No", no color bar added.)}

\item{label_by}{String specifying the column to label the samples (If NULL, the labels column of the SummarizedExperiment object is used. If "No", no labeling of samples done.)}
}
\value{
list of a ggplot object and the dataframe of outliers
}
\description{
Plot total protein intensity per sample
}
\examples{
data(tuberculosis_TMT_se)
plot_tot_int_samples(tuberculosis_TMT_se, ain="raw", color_by = NULL,
                     label_by = NULL)

}
