% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaLMM.R
\name{PomaLMM}
\alias{PomaLMM}
\title{Linear Mixed Models}
\usage{
PomaLMM(data, x = NULL, y = NULL, adjust = "fdr", clean_plot = FALSE)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{x}{Character vector. Indicates the names of \code{colData} columns to be used as random and fixed effects (independent variables). If it's set to NULL (default), all variables in \code{colData} will be used.}

\item{y}{Character vector. Indicates the names of dependent variables. If it's NULL (default), all features will be used.}

\item{adjust}{Character. Multiple comparisons correction method to adjust p-values. Available options are: "fdr" (false discovery rate), "holm", "hochberg", "hommel", "bonferroni", "BH" (Benjamini-Hochberg), and "BY" (Benjamini-Yekutieli).}

\item{clean_plot}{Logical. Indicates if remove intercept and linear mixed model residues boxplots from the plot. Defasult is FALSE.}
}
\value{
A \code{list} with results including plots and tables. Table values indicate the percentage variance explained per variable.
}
\description{
\code{PomaLMM} performs linear mixed models on a \code{SummarizedExperiment} object.
}
\examples{
data <- POMA::st000284 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `lm_table` (tibble) and `regression_plot` (ggplot2 object)
## Perform linear mixed model with all features
#data \%>\%
#  PomaLMM()
#
## Perform linear mixed model with two features
#data \%>\% 
#  PomaLMM(y = c("x1_methyladenosine", "x1_methylhistamine"))
#
## Perform linear mixed model with one random effect
#data \%>\% 
#  PomaLMM(x = "smoking_condition")
#
## Perform linear mixed model with two random effects and two features
#data \%>\% 
#  PomaLMM(x = c("smoking_condition", "gender"),
#          y = c("x1_methyladenosine", "x1_methylhistamine"))
#
## Perform linear mixed model with no random effects and two features, therefore, a linear model will be fitted
#data \%>\% 
#  PomaLMM(x = "age_at_consent", # Numerical, i.e., fixed effect
#          y = c("x1_methyladenosine", "x1_methylhistamine"))
#
## Perform linear mixed model with no random effects and all features, therefore, a linear model will be fitted
#data \%>\% 
#  PomaLMM(x = "age_at_consent") # Numerical i.e., fixed effect
}
\author{
Pol Castellano-Escuder
}
