% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaImpute.R
\name{PomaImpute}
\alias{PomaImpute}
\title{Impute Missing Values}
\usage{
PomaImpute(
  data,
  zeros_as_na = FALSE,
  remove_na = TRUE,
  cutoff = 20,
  group_by = NULL,
  method = "knn"
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{zeros_as_na}{Logical. Indicates if the zeros in the data are missing values. Default is FALSE.}

\item{remove_na}{Logical. Indicates if features with a percentage of missing values over the \code{cutoff} parameter should be removed. Default is TRUE.}

\item{cutoff}{Numeric. Percentage of missing values allowed in each feature.}

\item{group_by}{Character. Indicates the name of the \code{colData} column to be used as the grouping factor. Default is NULL (no grouping). This variable specifies the grouping criteria for evaluating missing values. Missing values will be assessed within each group defined by this variable, and features will be removed only if all groups exceed the allowed threshold of missing values.}

\item{method}{Character. The imputation method to use. Options include "none" (no imputation, replace missing values by zeros), "half_min" (replace missing values with half of the minimum value), "median" (replace missing values with the median), "mean" (replace missing values with the mean), "min" (replace missing values with the minimum value), "knn" (replace missing values using k-nearest neighbors imputation), and "random_forest" (replace missing values using random forest imputation).}
}
\value{
A \code{SummarizedExperiment} object without missing values.
}
\description{
\code{PomaImpute} performs missing value imputation on a dataset using various imputation methods.
}
\examples{
# Output is a imputed SummarizedExperiment object
data <- POMA::st000284 # Example SummarizedExperiment object included in POMA

# No sample normalization
data \%>\% 
  PomaImpute(zeros_as_na = FALSE,
             remove_na = TRUE,
             cutoff = 20,
             group_by = NULL,
             method = "knn")
}
\references{
Armitage, E. G., Godzien, J., Alonso‐Herranz, V., López‐Gonzálvez, Á., & Barbas, C. (2015). Missing value imputation strategies for metabolomics data. Electrophoresis, 36(24), 3050-3060.
}
\author{
Pol Castellano-Escuder
}
