#' @keywords internal
"_PACKAGE"

## usethis namespace: start
## usethis namespace: end
NULL

#' PMScanR: Protein Motif Scanning and Analysis
#'
#' PMScanR provides a suite of tools for identifying, analyzing, and
#' visualizing protein motifs. It integrates the PROSITE 'ps_scan' tool,
#' handles data conversion, and offers multiple visualization methods,
#' including heatmaps, pie charts, and sequence logos. The package also
#' features a full interactive Shiny application for a code-free workflow.
#'
#' @seealso
#' Useful functions:
#' \itemize{
#'   \item \code{\link{runPsScan}} For running the command-line analysis.
#'   \item \code{\link{runPMScanRShiny}} For launching the interactive application.
#'   \item \code{\link{readProsite}} For parsing PROSITE scan output.
#' }
#'
#' For a detailed tutorial, please see the package vignette:
#' \code{vignette("PMScanR", package = "PMScanR")}
#'
#' @name PMScanR-package
