% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/managing_batch_effects.R
\name{percentile_norm}
\alias{percentile_norm}
\title{Percentile normalisation}
\usage{
percentile_norm(data, batch, trt, ctrl.grp)
}
\arguments{
\item{data}{A data frame or matrix that contains the microbial variables
to be corrected for batch effects. Samples are in rows and variables
are in columns.}

\item{batch}{A factor or vector for the batch grouping information
(categorical outcome variable). Its length must match the number of rows
in \code{data}.}

\item{trt}{A factor or vector for the treatment grouping information
(categorical outcome variable). Its length must match the number of rows
in \code{data}.}

\item{ctrl.grp}{Character, the label of control samples (i.e. healthy) in
\code{trt}.}
}
\value{
A data frame with batch effects corrected by percentile
normalisation.
}
\description{
This function corrects for batch effects in case-control microbiome studies.
Briefly, the relative abundance of microbial variables (i.e. bacterial taxa)
in case (i.e. disease) samples is converted to percentiles of the
corresponding variables in control (i.e. healthy) samples within each batch,
before pooling data across batches. Pooled batches must share comparable
case and control cohort definitions.
}
\examples{
if (requireNamespace("SummarizedExperiment", quietly = TRUE)) {
    data("AD_data")

    # centered log ratio transformed data
    ad.clr <- SummarizedExperiment::assays(AD_data$EgData)$Clr_value
    ad.batch <- SummarizedExperiment::rowData(AD_data$EgData)$Y.bat # batch information
    ad.trt <- SummarizedExperiment::rowData(AD_data$EgData)$Y.trt # treatment information
    names(ad.batch) <- names(ad.trt) <- rownames(AD_data$EgData)
    ad.PN <- percentile_norm(
        data = ad.clr, batch = ad.batch,
        trt = ad.trt, ctrl.grp = "0-0.5"
    )
}

}
\references{
\insertRef{gibbons2018correcting}{PLSDAbatch}
}
\seealso{
\code{\link{linear_regres}} and \code{\link{PLSDA_batch}} as
other methods for batch effect management.
}
\author{
Yiwen Wang, Kim-Anh Le Cao
}
