% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_color.R
\name{lighten}
\alias{lighten}
\title{Lighten Colors by Increasing Brightness}
\usage{
lighten(colvec, amount = 0.15)
}
\arguments{
\item{colvec}{A vector of colors specified as character strings
(for example, hexadecimal colors or any color name recognized by R).}

\item{amount}{A scalar numeric value indicating how much brightness
to add. Must be between \code{0} and \code{1}. Default is \code{0.15}.}
}
\value{
A character vector of lightened colors in hexadecimal RGB format.
}
\description{
This function takes one or more colors and increases their brightness
by adding a constant amount to their RGB values. The adjustment is
performed in the RGB space, and the resulting values are truncated
to stay within \code{[0, 1]}. Alpha channels are not preserved and
the returned colors are fully opaque.
}
\examples{
lighten("#336699")
lighten(c("red", "blue"), amount = 0.1)
lighten(pb_color(seq_len(3)), amount = 0.2)

}
\seealso{
\code{\link{darken}}, \code{\link{pb_color}}
}
\author{
Yiwen Wang, Kim-Anh Le Cao
}
