% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_detection.R
\name{Scatter_Density}
\alias{Scatter_Density}
\title{Scatter Plot of Components with Marginal Density Plots}
\usage{
Scatter_Density(
  components,
  comp = c(1, 2),
  expl.var = NULL,
  batch = NULL,
  trt = NULL,
  xlim = NULL,
  ylim = NULL,
  color.set = NULL,
  shape.set = NULL,
  batch.legend.title = "Batch",
  trt.legend.title = "Treatment",
  density.lwd = 0.2,
  title = NULL,
  title.cex = 1.5,
  legend.cex = 0.7,
  legend.title.cex = 0.75
)
}
\arguments{
\item{components}{A numeric matrix or data frame containing component
scores. Samples are in rows and components in columns.}

\item{comp}{Integer vector of length two indicating which components
to plot on the x and y axes respectively, for example \code{c(1, 2)}
or \code{c(1, 3)}.}

\item{expl.var}{Optional numeric vector giving the proportion of variance
explained by each component. If provided, it should have length at least
\code{max(comp)} and is used to annotate the axis labels.}

\item{batch}{Optional factor or vector giving batch grouping information
(categorical outcome). If provided, its length must match the number of
samples in \code{components}. When present, points and density plots are
coloured by batch.}

\item{trt}{Optional factor or vector giving treatment grouping
information (categorical outcome). If provided, its length must match
the number of samples in \code{components}. When present, points and
density plots are further distinguished by treatment-specific shapes
or line types.}

\item{xlim}{Optional numeric vector of length two giving the x-axis
limits for the scatter plot. If \code{NULL}, limits are chosen
automatically from the data.}

\item{ylim}{Optional numeric vector of length two giving the y-axis
limits for the scatter plot. If \code{NULL}, limits are chosen
automatically from the data.}

\item{color.set}{Optional character vector of colours (hexadecimal codes)
used to represent batch levels. If \code{NULL} and \code{batch} is
provided, an internal palette is used and extended when the number of
batches exceeds the base palette size. If \code{batch} is \code{NULL},
this argument is ignored.}

\item{shape.set}{Optional numeric vector of plotting characters
used to represent treatment levels. If \code{NULL} and \code{trt} is
provided, an internal sequence of hollow and solid shapes is used.
If \code{trt} is \code{NULL}, this argument is ignored and a fixed
shape is used.}

\item{batch.legend.title}{Character string giving the legend title
for batch.}

\item{trt.legend.title}{Character string giving the legend title
for treatment.}

\item{density.lwd}{Numeric value giving the line width for the density
curves in the marginal plots.}

\item{title}{Character string giving the main title.}

\item{title.cex}{Numeric value controlling the relative size of the
main title.}

\item{legend.cex}{Numeric value controlling the relative size of legend
text.}

\item{legend.title.cex}{Numeric value controlling the relative size of
legend titles.}
}
\value{
A grob object containing the combined scatter
and density plots.
}
\description{
This function draws a sample scatter plot for two selected components,
together with marginal density plots along each axis.
It is generic in the sense that it only requires a matrix or dataframe
of component scores, and can therefore be used with PCA, PLS or any
other multivariate method that returns component scores.
}
\examples{
if (requireNamespace("mixOmics", quietly = TRUE) &&
    requireNamespace("SummarizedExperiment", quietly = TRUE)) {
    ## Example using a PCA object from mixOmics

    data("AD_data")

    ## centered log-ratio transformed data
    ad.clr <- SummarizedExperiment::assays(AD_data$EgData)$Clr_value
    ad.pca <- mixOmics::pca(ad.clr, ncomp = 3, scale = TRUE)

    ad.batch <- SummarizedExperiment::rowData(AD_data$EgData)$Y.bat # batch information
    ad.trt <- SummarizedExperiment::rowData(AD_data$EgData)$Y.trt # treatment information
    names(ad.batch) <- names(ad.trt) <- rownames(AD_data$EgData)

    ## components and explained variance extracted from the PCA object
    comp.mat <- ad.pca$variates$X
    expl.var <- ad.pca$prop_expl_var$X

    ## Scatter plot of the first two components
    Scatter_Density(
        components = comp.mat,
        comp = c(1, 2),
        expl.var = expl.var,
        batch = ad.batch,
        trt = ad.trt
    )

    ## Scatter plot of components 1 and 3, with a user-defined colour set
    cols <- rainbow(10)
    Scatter_Density(
        components = comp.mat,
        comp = c(1, 3),
        expl.var = expl.var,
        batch = ad.batch,
        trt = ad.trt,
        color.set = cols
    )
}

}
\seealso{
\code{\link{box_plot}}, \code{\link{density_plot}},
\code{\link{alignment_score}} and \code{\link{partVar_plot}} as other
methods for batch effect detection and batch effect removal assessment.
}
\author{
Yiwen Wang, Kim-Anh Le Cao
}
