% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormForSine.R
\name{NormForSine}
\alias{NormForSine}
\title{Rescale the gene/isoform expression matrix}
\usage{
NormForSine(Data, qt1=.05, qt2=.95)
}
\arguments{
\item{Data}{input gene-by-sample matrix or isoform-by-sample matrix}

\item{qt1,qt2}{thresholds for outlier adjustment. For each gene/isoform,
values <= qt1 th quantile (>= qt2 th quantile)
will be pushed to qt1 th quantile (qt2 th quantile) prior to the scaling.
default values are 0.05 and 0.95.}
}
\value{
The output will be a gene-by-sample or isoform-by-sample matrix.
For each gene/isoform, the expressions will be scaled linearly to [-1,1]
}
\description{
Rescale the gene/isoform expression matrix
}
\examples{
NormForSine(matrix(rnorm(10), nrow=2))
}
\author{
Ning Leng
}

