% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/FlagCluster.R
\name{FlagCluster}
\alias{FlagCluster}
\title{Flag gene clusters with small within-cluster phase differences and/or small within-cluster sine scores}
\usage{
FlagCluster(SineRes, KMRes, Data, qt, thre=pi/4, qtincluster=.5, qtinpermu=.9 ,Seed=1)
}
\arguments{
\item{SineRes}{output of OscopeSine() function}

\item{KMRes}{output of KMRes() function}

\item{Data}{a gene-by-sample (isoform-by-sample) matrix indicating the rescaled expression of genes/isoforms.
all values should be between [-1, 1].}

\item{qt,thre}{Define a gene pair's linear score as
min(eta, pi-eta), in which eta is defined as phase shift mod pi.
A cluster will be flagged if the
qt th quantile of within-cluster linear score is less than thre.}

\item{qtincluster,qtinpermu}{To define clusters with small within-cluster sine scores, for each cluster we generate
permuted data of these genes (different cell permutation for each gene).
We calculate the within-cluster sine scores within
the cluster of permuted genes, then infer whether the sine scores
in the cluster of interest are greater than those generated by the permuted genes.
A cluster will be flagged if its qtincluster th quantile in the original data is less than
its qtinpermu th quantile in permuted data.}

\item{Seed}{seed}
}
\value{
Output: RemoveID: a vector of cluster numbers that are flagged;
SineCompreList: sine score and permuted sine score for each cluster;  LinearList: linear score of each cluster
}
\description{
Flag gene clusters with small within-cluster phase differences and/or small within-cluster sine scores
}
\examples{
aa <- sin(seq(0,1,.1))
bb <- sin(seq(0.5,1.5,.1))
cc <- sin(seq(0.9,1.9,.1))
tmp <- matrix(sin(rnorm(330)),ncol=11)
rownames(tmp) <- paste0("tmp",1:30)
Dat <- rbind(aa, bb, cc, tmp)
res1 <- OscopeSine(Dat)
res2 <- OscopeKM(res1, quan=.8, maxK=5)
res <- FlagCluster(res1, res2, Dat)
}
\author{
Ning Leng
}

