% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log.R
\name{omnipath_msg}
\alias{omnipath_msg}
\title{Dispatch a message to the OmnipathR logger}
\usage{
omnipath_msg(level, ...)
}
\arguments{
\item{level}{Character, numeric or class loglevel. A log level, if
character one of the followings: "fatal", "error", "warn", "success",
"info", "trace".}

\item{...}{Arguments for string formatting, passed \code{sprintf} or
\code{str_glue}.}
}
\value{
Returns `NULL`.
}
\description{
Any package or script can easily send log messages and establish a logging
facility with the fantastic `logger` package. This function serves the
only purpose if you want to inject messages into the logger of OmnipathR.
Otherwise we recommend to use the `logger` package directly.
}
\examples{
omnipath_msg(
    level = 'success',
    'Talking to you in the name of OmnipathR, my favourite number is \%d',
    round(runif(1, 1, 10))
)

}
