% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_test}
\alias{nichenet_test}
\title{Run the NicheNet pipeline with a little dummy network}
\usage{
nichenet_test(...)
}
\arguments{
\item{...}{Passed to \code{\link{nichenet_main}}.}
}
\value{
A named list with the intermediate and final outputs of the
    pipeline: `networks`, `expression`, `optimized_parameters`,
    `weighted_networks` and `ligand_target_matrix`.
}
\description{
Loads a tiny network and runs the NicheNet pipeline with low number of
iterations in the optimization process. This way the pipeline runs in
a reasonable time in order to test the code. Due to the random subsampling
disconnected networks might be produced sometimes. If you see an error
like "Error in if (sd(prediction_vector) == 0) ... missing value
where TRUE/FALSE needed", the random subsampled input is not appropriate.
In this case just interrupt and call again. This test ensures the
computational integrity of the pipeline. If it fails during the
optimization process, try to start it over several times, even
restarting R. The unpredictability is related to \code{mlrMBO} and
\code{nichenetr} not being prepared to handle certain conditions, and
it's also difficult to find out which conditions lead to which errors.
At least 3 different errors appear time to time, depending on the input.
It also seems like restarting R sometimes helps, suggesting that the
entire system might be somehow stateful. You can ignore the \code{
Parallelization was not stopped} warnings on repeated runs.
}
\examples{
\dontrun{
nnt <- nichenet_test()
}

}
