% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_remove_orphan_ligands}
\alias{nichenet_remove_orphan_ligands}
\title{Removes experiments with orphan ligands}
\usage{
nichenet_remove_orphan_ligands(expression, lr_network)
}
\arguments{
\item{expression}{Expression data as returned by
\code{\link{nichenet_expression_data}}.}

\item{lr_network}{A NicheNet format ligand-recptor network data frame as
produced by \code{\link{nichenet_lr_network}}.}
}
\value{
The same list as `expression` with certain elements removed.
}
\description{
Removes from the expression data the perturbation experiments involving
ligands without connections.
}
\examples{
lr_network <- nichenet_lr_network()
expression <- nichenet_expression_data()
expression <- nichenet_remove_orphan_ligands(expression, lr_network)

}
