% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_ligand_activities}
\alias{nichenet_ligand_activities}
\title{Calls the NicheNet ligand activity analysis}
\usage{
nichenet_ligand_activities(
  ligand_target_matrix,
  lr_network,
  expressed_genes_transmitter,
  expressed_genes_receiver,
  genes_of_interest,
  background_genes = NULL,
  n_top_ligands = 42,
  n_top_targets = 250
)
}
\arguments{
\item{ligand_target_matrix}{A matrix with rows and columns corresponding
to ligands and targets, respectively. Produced by
\code{\link{nichenet_ligand_target_matrix}} or
\code{nichenetr::construct_ligand_target_matrix}.}

\item{lr_network}{A data frame with ligand-receptor interactions, as
produced by \code{\link{nichenet_lr_network}}.}

\item{expressed_genes_transmitter}{Character vector with the gene symbols
of the genes expressed in the cells transmitting the signal.}

\item{expressed_genes_receiver}{Character vector with the gene symbols
of the genes expressed in the cells receiving the signal.}

\item{genes_of_interest}{Character vector with the gene symbols of the
genes of interest. These are the genes in the receiver cell population
that are potentially affected by ligands expressed by interacting
cells (e.g. genes differentially expressed upon cell-cell interaction).}

\item{background_genes}{Character vector with the gene symbols of the
genes to be used as background.}

\item{n_top_ligands}{How many of the top ligands to include in the
ligand-target table.}

\item{n_top_targets}{For each ligand, how many of the top targets to
include in the ligand-target table.}
}
\value{
A named list with `ligand_activities` (a tibble giving several
    ligand activity scores; following columns in the tibble: $test_ligand,
    $auroc, $aupr and $pearson) and `ligand_target_links` (a tibble with
    columns ligand, target and weight (i.e. regulatory potential score)).
}
\description{
Calls the NicheNet ligand activity analysis
}
\examples{
\dontrun{
networks <- nichenet_networks()
expression <- nichenet_expression_data()
optimization_results <- nichenet_optimization(networks, expression)
nichenet_model <- nichenet_build_model(optimization_results, networks)
lt_matrix <- nichenet_ligand_target_matrix(
    nichenet_model$weighted_networks,
    networks$lr_network,
    nichenet_model$optimized_parameters
)
ligand_activities <- nichenet_ligand_activities(
    ligand_target_matrix = lt_matrix,
    lr_network = networks$lr_network,
    # the rest of the parameters should come
    # from your transcriptomics data:
    expressed_genes_transmitter = expressed_genes_transmitter,
    expressed_genes_receiver = expressed_genes_receiver,
    genes_of_interest = genes_of_interest
)
}

}
