% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nichenet.R
\name{nichenet_gr_network_evex}
\alias{nichenet_gr_network_evex}
\title{NicheNet gene regulatory network from EVEX}
\usage{
nichenet_gr_network_evex(
  top_confidence = 0.75,
  indirect = FALSE,
  regulation_of_expression = FALSE
)
}
\arguments{
\item{top_confidence}{Double, between 0 and 1. Threshold based on the
quantile of the confidence score.}

\item{indirect}{Logical: whether to include indirect interactions.}

\item{regulation_of_expression}{Logical: whether to include also the
"regulation of expression" type interactions.}
}
\value{
Data frame of interactions in NicheNet format.

Data frame with gene regulatory interactions in NicheNet format.
}
\description{
Builds a gene regulatory network using data from the EVEX database
and converts it to a format suitable for NicheNet.
}
\examples{
# use only the 10\% with the highest confidence:
evex_gr_network <- nichenet_gr_network_evex(top_confidence = .9)

}
\seealso{
\itemize{
    \item{\code{\link{nichenet_gr_network}}}
    \item{\code{\link{evex_download}}}
}
}
