% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{latin_name}
\alias{latin_name}
\title{Latin (scientific) names of organisms}
\usage{
latin_name(name)
}
\arguments{
\item{name}{Vector with any kind of organism name or identifier, can be
also mixed type.}
}
\value{
Character vector with latin (scientific) names, NA if a name
    in the input could not be found.
}
\description{
Latin (scientific) names of organisms
}
\examples{
latin_name(c(9606, "cat", "dog"))
# [1] "Homo sapiens" "Felis catus" "Canis lupus familiaris"
latin_name(c(9606, "cat", "doggy"))
# [1] "Homo sapiens" "Felis catus"  NA

}
\seealso{
\itemize{
    \item{\code{\link{ncbi_taxid}}}
    \item{\code{\link{common_name}}}
    \item{\code{\link{ensembl_name}}}
}
}
