% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbmanager.R
\name{get_db}
\alias{get_db}
\title{Access a built in database}
\usage{
get_db(key, param = NULL, reload = FALSE, ...)
}
\arguments{
\item{key}{Character: the key of the database to load. For a list of
available keys see \code{\link{omnipath_show_db}}.}

\item{param}{List: override the defaults or pass further parameters to
the database loader function. See the loader functions and their
default parameters in \code{\link{omnipath_show_db}}. If the database
is already loaded with different parameters it will be reloaded
with the new parameters only if the \code{reload} option is
\code{TRUE}.}

\item{reload}{Reload the database if \code{param} passed here is different
from the parameters used the last time the database was loaded. If
different functions with different parameters access the database
repeatedly and request reload the frequent reloads might cost
substantial time and resource use.}

\item{...}{Arguments for the loader function of the database. These
override the default arguments.}
}
\value{
An object with the database contents. The exact format depends
    on the database, most often it is a data frame or a list.
}
\description{
Databases are resources which might be costly to load but can be used many
times by functions which usually automatically load and retrieve them from
the database manager. Each database has a lifetime and will be unloaded
automatically upon expiry.
}
\examples{
organisms <- get_db('organisms')

}
\seealso{
\code{\link{omnipath_show_db}}.
}
