% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extra_attrs.R
\name{extra_attrs}
\alias{extra_attrs}
\title{Extra attribute names in an interaction data frame}
\usage{
extra_attrs(data)
}
\arguments{
\item{data}{An interaction data frame, as provided by any of the
\code{\link{omnipath-interactions}} functions.}
}
\value{
Character: the names of the extra attributes in the data frame.
}
\description{
Interaction data frames might have an `extra_attrs` column if this field
has been requested in the query by passing the `fields = 'extra_attrs'
argument. This column contains resource specific attributes for the
interactions. The names of the attributes consist of the name of the
resource and the name of the attribute, separated by an underscore.
This function returns the names of the extra attributes available in
the provided data frame.
}
\examples{
i <- omnipath(fields = "extra_attrs")
extra_attrs(i)

}
\seealso{
\itemize{
    \item{\code{\link{extra_attrs_to_cols}}}
    \item{\code{\link{has_extra_attrs}}}
    \item{\code{\link{with_extra_attrs}}}
    \item{\code{\link{filter_extra_attrs}}}
    \item{\code{\link{extra_attr_values}}}
}
}
