% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-OutriderDataSet.R
\name{makeExampleOutriderDataSet}
\alias{makeExampleOutriderDataSet}
\title{Create example data sets for OUTRIDER}
\usage{
makeExampleOutriderDataSet(
  n = 200,
  m = 80,
  q = 10,
  freq = 0.001,
  zScore = 6,
  inj = c("both", "low", "high"),
  sf = rnorm(m, mean = 1, sd = 0.1),
  dataset = c("none", "GTExSkinSmall", "KremerNBaderSmall")
)
}
\arguments{
\item{n}{Number of simulated genes}

\item{m}{Number of simulated samples}

\item{q}{number of simulated latend variables.}

\item{freq}{Frequency of in-silico outliers}

\item{zScore}{Absolute z score of in-silico outliers (default 6).}

\item{inj}{Determines whether counts are injected with the strategy 
('both', 'low', 'high'), default is 'both'.}

\item{sf}{Artificial Size Factors}

\item{dataset}{If "none", the default, an example data set is simulated. 
One can also use example data set included in the package by
specifying 'GTExSkinSmall' or 'KremerNBaderSmall'}
}
\value{
An OutriderDataSet containing an example dataset. Depending on the
           parameters it is based on a real data set or it is simulated
}
\description{
Creates an example data set from a file or simulates a data set based 
on random counts following a negative binomial distribution with injected
outliers with a fixed z score away from the mean of the gene.
}
\examples{
# A generic dataset 
ods1 <- makeExampleOutriderDataSet()
ods1

# A generic dataset with specificed sample size and injection method
ods2 <- makeExampleOutriderDataSet(n=200, m=50, inj='low')
ods2

# A subset of a real world dataset from GTEx 
ods3 <- makeExampleOutriderDataSet(dataset="GTExSkinSmall")
ods3

}
