% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_region.R
\name{windowPerGroup}
\alias{windowPerGroup}
\title{Get window region of GRanges object}
\usage{
windowPerGroup(gr, tx, upstream = 0L, downstream = 0L)
}
\arguments{
\item{gr}{a GRanges/IRanges object (startSites or others,
must be single point per in genomic coordinates)}

\item{tx}{a \code{\link{GRangesList}} of transcripts or (container region),
names of tx must contain all gr names. The names of gr can also be the
ORFik orf names. that is "txName_id".}

\item{upstream}{an integer, default (0), relative region to get
upstream end from. (0 means start site, +1 is one upstream, -1 is one downstream)}

\item{downstream}{an integer, default (0), relative region to get
downstream end from (0 means start site, +1 is one downstream, -1 is one upstream)}
}
\value{
a GRanges, or GRangesList object if any group had > 1 exon.
}
\description{
Per GRanges input (gr) of single position inputs (center point),
create a GRangesList window output of specified
upstream, downstream region relative to some transcript "tx". \cr
If downstream is 20, it means the window will start 20 downstream of
gr start site (-20 in relative transcript coordinates.)
If upstream is 20, it means the window will start 20 upstream of
gr start site (+20 in relative transcript coordinates.)
It will keep exon structure of tx, so if -20 is on next exon, it jumps to
next exon.
}
\details{
If a region has a part that goes out of bounds, E.g if you try to get window
around the CDS start site, goes longer than the 5' leader start site,
it will set start to the edge boundary
(the TSS of the transcript in this case).
If region has no hit in bound, a width 0 GRanges object is returned.
This is useful for things like countOverlaps, since 0 hits will then always
be returned for the correct object index. If you don't want the 0 width
windows, use \code{reduce()} to remove 0-width windows.
}
\examples{
# find 2nd codon of an ORF on a spliced transcript
ORF <- GRanges("1", c(3), "+") # start site
names(ORF) <- "tx1_1" # ORF 1 on tx1
tx <- GRangesList(tx1 = GRanges("1", c(1,3,5,7,9,11,13), "+"))
windowPerGroup(ORF, tx, upstream = 0, downstream = 0) # <- TIS
windowPerGroup(ORF, tx, upstream = 0, downstream = 1) # <- first and second base
windowPerGroup(ORF, tx, upstream = -1, downstream = 1) # <- second base
# find 2nd codon of an ORF on a spliced transcript
windowPerGroup(ORF, tx, upstream = -3, downstream = 5) # <- 2nd codon

# With multiple extensions downstream
ORF <- rep(ORF, 2)
names(ORF)[2] <- "tx1_2"
windowPerGroup(ORF, tx, upstream = 0, downstream = c(2, 5))
# The last one gives 2nd for first ORF and (1st and 2nd) codon for
# second ORF, returned as two groups of class GRanges/GRangsList

}
\seealso{
Other ExtendGenomicRanges: 
\code{\link{asTX}()},
\code{\link{coveragePerTiling}()},
\code{\link{extendLeaders}()},
\code{\link{extendTrailers}()},
\code{\link{reduceKeepAttr}()},
\code{\link{tile1}()},
\code{\link{txSeqsFromFa}()}
}
\concept{ExtendGenomicRanges}
