% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_plots.R
\name{te.plot}
\alias{te.plot}
\title{Translational efficiency plots}
\usage{
te.plot(
  df.rfp,
  df.rna,
  output.dir = QCfolder(df.rfp),
  type = c("default", "between"),
  filter.rfp = 1,
  filter.rna = 1,
  collapse = FALSE,
  plot.title = "",
  plot.ext = ".pdf",
  width = 6,
  height = "auto"
)
}
\arguments{
\item{df.rfp}{a \code{\link{experiment}} of Ribo-seq or 80S from TCP-seq.}

\item{df.rna}{a \code{\link{experiment}} of RNA-seq}

\item{output.dir}{directory to save plots, plots will be named
"TE_between.pdf" and "TE_within.pdf"}

\item{type}{which plots to make, default: c("default", "between"). Both plots.}

\item{filter.rfp}{numeric, default 1. minimum fpkm value to be included in plots}

\item{filter.rna}{numeric, default 1. minimum fpkm value to be included in plots}

\item{collapse}{a logical/character (default FALSE), if TRUE all samples
within the group SAMPLE will be collapsed to one. If "all", all
groups will be merged into 1 column called merged_all. Collapse is defined
as rowSum(elements_per_group) / ncol(elements_per_group)}

\item{plot.title}{title for plots, usually name of experiment etc}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{width}{numeric, default 6 (in inches)}

\item{height}{numeric or character, default "auto", which is:
3 + (ncol(RFP_CDS_FPKM)-2).
Else a numeric value of height (in inches)}
}
\value{
a data.table with TE values, fpkm and log fpkm values, library
samples melted into rows with split variable called "variable".
}
\description{
Create 2 TE plots of:\cr
- Within sample (TE log2 vs mRNA fpkm) ("default")\cr
- Between all combinations of samples
(x-axis: rna1fpkm - rna2fpkm, y-axis rfp1fpkm - rfp2fpkm)
}
\details{
Ribo-seq and RNA-seq must have equal nrows, with matching samples. Only
exception is if RNA-seq is 1 single sample. Then it will use that for
each of the Ribo-seq samples.
Same stages, conditions etc, with a unique pairing 1 to 1. If not you can
run collapse = "all". It will then merge all and do combined of all
RNA-seq vs all Ribo-seq
}
\examples{
##
# df.rfp <- read.experiment("zf_baz14_RFP")
# df.rna <- read.experiment("zf_baz14_RNA")
# te.plot(df.rfp, df.rna)
## Collapse replicates:
# te.plot(df.rfp, df.rna, collapse = TRUE)
}
