% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STAR.R
\name{install.fastp}
\alias{install.fastp}
\title{Download and prepare fastp trimmer}
\usage{
install.fastp(folder = "~/bin")
}
\arguments{
\item{folder}{path to folder for download, file will be named
"fastp", this should be most recent version. On mac it will search
for a folder called fastp-master inside folder given. Since there
is no precompiled version of fastp for Mac OS.}
}
\value{
path to runnable fastp
}
\description{
On Linux, will not run "make", only use precompiled fastp file.\cr
On Mac OS it will use precompiled binaries.\cr
For windows must be installed through WSL (Windows Subsystem Linux)
}
\examples{
## With default folder:
#install.fastp()

## Or set manual folder:
folder <- "~/I/WANT/IT/HERE/"
#install.fastp(folder)
}
\references{
https://www.ncbi.nlm.nih.gov/pmc/articles/PMC6129281/
}
\seealso{
Other STAR: 
\code{\link{STAR.align.folder}()},
\code{\link{STAR.align.single}()},
\code{\link{STAR.allsteps.multiQC}()},
\code{\link{STAR.index}()},
\code{\link{STAR.install}()},
\code{\link{STAR.multiQC}()},
\code{\link{STAR.remove.crashed.genome}()},
\code{\link{getGenomeAndAnnotation}()}
}
\concept{STAR}
