% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_plots.R
\name{cor_plot}
\alias{cor_plot}
\title{Get correlation between columns}
\usage{
cor_plot(
  dt_cor,
  col = c(low = "blue", high = "red", mid = "white", na.value = "white"),
  limit = c(ifelse(min(dt_cor$Cor, na.rm = TRUE) < 0, -1, 0), 1),
  midpoint = mean(limit),
  label_name = "Pearson\\nCorrelation",
  text_size = 4,
  legend.position = c(0.4, 0.7),
  legend.direction = "horizontal"
)
}
\arguments{
\item{dt_cor}{a data.table, with column Cor}

\item{col}{colors c(low = "blue", high = "red", mid = "white", na.value = "white")}

\item{limit}{default (-1, 1), defined by:
\code{c(ifelse(min(dt_cor$Cor, na.rm = TRUE) < 0, -1, 0), 1)}}

\item{midpoint}{midpoint of correlation values in label coloring.}

\item{label_name}{name of correlation method, default
\code{"Pearson Correlation"} with newline after Pearson.}

\item{text_size}{size of correlation numbers}

\item{legend.position}{default c(0.4, 0.7), other: "top", "right",..}

\item{legend.direction}{default "horizontal", or "vertical"}
}
\value{
a ggplot (heatmap)
}
\description{
Get correlation between columns
}
