% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Dif_expression_helpers.R
\name{DEG_model_simple}
\alias{DEG_model_simple}
\title{Simple Fpkm ratio test DEG}
\usage{
DEG_model_simple(
  df,
  target.contrast = design[1],
  design = ORFik::design(df),
  p.value = 0.05,
  counts = countTable(df, "mrna", type = "summarized"),
  design_ids = as.character(df[, target.contrast]),
  batch.effect = FALSE
)
}
\arguments{
\item{df}{an \code{\link{experiment}} of usually RNA-seq.}

\item{target.contrast}{a character vector, default \code{design[1]}.
The column in the ORFik experiment that represent the comparison contrasts.
By default: the first design factor of the full experimental design.
This is the factor you will do the comparison on. DESeq will normalize
the counts based on the full design, but the log fold change values will
be based on this contrast only. It is usually the 'condition' column.}

\item{design}{a character vector, default \code{design(df.rfp)}.
The full experiment design. Which factors have more than 1 level.
Example: stage column are all HEK293, so it can not be a design factor.
The condition column has 2 possible values, WT and mutant, so it is
a factor of the experiment. Replicates column is not part of design,
that is inserted later with setting \code{batch.effect = TRUE}.
Library type 'libtype' column, can also no be part of initial design,
it is always added inside the function, after initial setup.}

\item{p.value}{a numeric, default 0.05 in interval (0,1). Defines adjusted
p-value to be used as significance threshold for the result groups. I.e.
for exclusive translation group significant subset for p.value = 0.05 means:
TE$padj < 0.05 & Ribo$padj < 0.05 & RNA$padj > 0.05.}

\item{counts}{a SummarizedExperiment, default:
countTable(df, "mrna", type = "summarized"), all transcripts.
Assign a subset if you don't want to analyze all genes.
It is recommended to not subset, to give DESeq2 data for variance analysis.}

\item{design_ids}{character vector of contrast group ids, e.g.
c("WT", "WT", "Mutant", "Mutant")}

\item{batch.effect}{logical, default TRUE. Makes replicate column of the experiment
part of the design.\cr
If you believe you might have batch effects, keep as TRUE.
Batch effect usually means that you have a strong variance between
biological replicates. Check out \code{\link{pcaExperiment}} and see if replicates
cluster together more than the design factor, to verify if you need to set it to TRUE.}
}
\value{
a data.table of fpkm ratios
}
\description{
If you do not have a valid DESEQ2 experimental setup (contrast), you
can use this simplified test
}
\examples{
## Simple example (use ORFik template, then use only RNA-seq)
df <- ORFik.template.experiment()
df <- df[df$libtype == "RNA",]
#dt <- DEG_model_simple(df)
}
