% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence_features.R
\name{distToCds}
\alias{distToCds}
\title{Get distances between ORF ends and starts of their transcripts cds.}
\usage{
distToCds(ORFs, fiveUTRs, cds = NULL)
}
\arguments{
\item{ORFs}{orfs as \code{\link{GRangesList}},
names of orfs must be transcript names}

\item{fiveUTRs}{fiveUTRs as \code{\link{GRangesList}},
remember to use CAGE version of 5' if you did CAGE reassignment!}

\item{cds}{cds' as \code{\link{GRangesList}},
only add if you have ORFs going into CDS.}
}
\value{
an integer vector, +1 means one base upstream of cds, -1 means
2nd base in cds, 0 means orf stops at cds start.
}
\description{
Will calculate distance between each ORF end and begining of the
corresponding cds (main ORF). Matching is done by transcript names.
This is applicable practically to the upstream (fiveUTRs) ORFs only.
The cds start site, will be presumed to be on + 1 of end of fiveUTRs.
}
\examples{
grl <- GRangesList(tx1_1 = GRanges("1", IRanges(1, 10), "+"))
fiveUTRs <- GRangesList(tx1 = GRanges("1", IRanges(1, 20), "+"))
distToCds(grl, fiveUTRs)

}
\references{
doi: 10.1074/jbc.R116.733899
}
\seealso{
Other features: 
\code{\link{computeFeatures}()},
\code{\link{computeFeaturesCage}()},
\code{\link{countOverlapsW}()},
\code{\link{disengagementScore}()},
\code{\link{distToTSS}()},
\code{\link{entropy}()},
\code{\link{floss}()},
\code{\link{fpkm}()},
\code{\link{fpkm_calc}()},
\code{\link{fractionLength}()},
\code{\link{initiationScore}()},
\code{\link{insideOutsideORF}()},
\code{\link{isInFrame}()},
\code{\link{isOverlapping}()},
\code{\link{kozakSequenceScore}()},
\code{\link{orfScore}()},
\code{\link{rankOrder}()},
\code{\link{ribosomeReleaseScore}()},
\code{\link{ribosomeStallingScore}()},
\code{\link{startRegion}()},
\code{\link{startRegionCoverage}()},
\code{\link{stopRegion}()},
\code{\link{subsetCoverage}()},
\code{\link{translationalEff}()}
}
\concept{features}
